<?php

namespace App\Models\Listing;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Listing extends Model 
{

    protected $table = 'listings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function product_abstraction()
    {
        return $this->belongsTo('App\Models\Product\ProductAbstraction', 'product_abstraction_id');
    }

    public function markerplace()
    {
        return $this->belongsTo('App\Models\Listing\Marketplace', 'marketplace_id');
    }

    public function currency()
    {
        return $this->belongsTo('App\Models\Finance\Currency', 'currency_id');
    }

    public function lines()
    {
        return $this->hasMany('App\Models\Finance\Line', 'listing_id');
    }

}